<?php

namespace App\Model;

use Illuminate\Database\Eloquent\Model;

class Client extends Model 
{

    protected $table = 'clients';
    public $timestamps = true;

    public function order()
    {
        return $this->hasManyThrough('App\Model\Order');
    }

    public function comments()
    {
        return $this->hasMany('App\Model\Comment');
    }

    public function city()
    {
        return $this->belongsTo('App\Model\City', 'city_id');
    }

    public function distriction()
    {
        return $this->belongsTo('App\Model\Distriction', 'distriction_id');
    }

    public function notificationable()
    {
        return $this->morphMany('App\Model\Notificationable', 'notificationable');
    }

}